let hotelMap = {}; let sheetHeaders = []; let sheetRows = [];

window.onload = async () => {
    const res = await fetch('process.php?action=getInitialData');
    const data = await res.json();
    const dSel = document.getElementById('destSelect');
    data.destinations.forEach(f => dSel.add(new Option(f.replace('.csv',''), f)));
    const sS = document.getElementById('salesStaff'); const oS = document.getElementById('opsStaff');
    data.staff.sales.forEach(n => sS.add(new Option(n, n)));
    data.staff.ops.forEach(n => oS.add(new Option(n, n)));
};

async function loadPricingData() {
    const file = document.getElementById('destSelect').value;
    const res = await fetch(`process.php?action=getDestData&file=${file}`);
    const data = await res.json();
    sheetHeaders = data.headers; sheetRows = data.rows;
    hotelMap = {}; let cities = [];
    sheetRows.forEach(row => {
        let city = row[22], hotel = row[23];
        if (city && hotel) {
            if (!hotelMap[city]) { hotelMap[city] = []; cities.push(city); }
            if (!hotelMap[city].includes(hotel)) hotelMap[city].push(hotel);
        }
    });
    document.querySelectorAll('.hCity').forEach(sel => {
        sel.innerHTML = '<option value="">-- City --</option>';
        [...new Set(cities)].sort().forEach(c => sel.add(new Option(c, c)));
    });
}

function autoGrow(el) { el.style.height = "5px"; el.style.height = (el.scrollHeight) + "px"; }

function autoPrice(el) {
    const row = el.closest('.activity-item');
    const act = row.querySelector('.activity-sel').value;
    const car = row.querySelector('.car-sel').value;
    const vIdx = sheetHeaders.indexOf(car);
    const actRow = sheetRows.find(r => r[0] === act);
    if (actRow && vIdx !== -1) { row.querySelector('.itin-cost').value = actRow[vIdx] || 0; }
    calculateTotal();
}

function calculateTotal() {
    let t = 0;
    document.querySelectorAll('.hCost, .itin-cost').forEach(i => t += parseFloat(i.value) || 0);
    document.getElementById('grandTotal').innerText = t.toLocaleString(undefined, {minimumFractionDigits: 2});
}